% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_calls.R
\name{unnest_calls}
\alias{unnest_calls}
\title{Unnest R calls}
\usage{
unnest_calls(.data, input, drop = TRUE)
}
\arguments{
\item{.data}{A data frame}

\item{input}{Input column that contains an R call or list of R calls to be
split into individual functions}

\item{drop}{\code{logical}. Whether the original input column should be dropped.}
}
\value{
The original data frame with an additional three columns:
\itemize{
\item \code{line}: the line number of the call
\item \code{func}: the name of the function called
\item \code{args}: a list of arguments
}
}
\description{
Unnest R calls
}
\examples{
d <- read_rfiles(tidycode_example("example_plot.R"))

# Unnest a model call
d \%>\%
  unnest_calls(expr)

# Unnest a model call and keep the call itself using the drop parameter
d \%>\%
  unnest_calls(expr, drop = FALSE)
}
