% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescaling.R
\name{rescaling}
\alias{rescaling}
\alias{rescale_zscore}
\alias{rescale_minmax}
\alias{rescale_center}
\title{The rescaling module}
\usage{
rescaling(data, ...)

rescale_zscore(var, na.rm = TRUE)

rescale_minmax(var, min = NULL, max = NULL, na.rm = TRUE, censor = TRUE)

rescale_center(var, na.rm = TRUE)
}
\arguments{
\item{data}{an index table object, see [tidyindex::init()]}

\item{...}{used in \code{rescaling}, a rescaling object of class
\code{rescale}, currently one of the \code{rescale_zscore()},
\code{rescale_minmax()}, and \code{rescale_center()},}

\item{var}{the variable(s) to rescale, accept tidyselect syntax}

\item{na.rm}{used in \code{rescale_*()}, logical, whether to remove NAs}

\item{min, max}{used in \code{rescale_minmax()}, the minimum and maximum value}

\item{censor}{used in \code{rescale_minmax()}, logical;
whether to censor points outside min and max, if provided}
}
\value{
an index table object
}
\description{
The rescale module changes the scale of the variable(s) using one of the
available rescaling functions: \code{rescale_zscore()},
\code{rescale_minmax()}, and \code{rescale_center}.
}
\examples{
dt <- hdi |> init()
dt |> rescaling(life_exp = rescale_zscore(life_exp))
dt |> rescaling(life_exp2 = rescale_minmax(life_exp, min = 20, max = 85))
}
