% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_gemini.R
\name{send_gemini_batch}
\alias{send_gemini_batch}
\title{Submit a list of LLMMessage objects to Gemini's batch API}
\usage{
send_gemini_batch(
  .llms,
  .model = "gemini-2.5-flash",
  .temperature = NULL,
  .max_output_tokens = NULL,
  .top_p = NULL,
  .top_k = NULL,
  .presence_penalty = NULL,
  .frequency_penalty = NULL,
  .stop_sequences = NULL,
  .safety_settings = NULL,
  .json_schema = NULL,
  .grounding_threshold = NULL,
  .timeout = 120,
  .dry_run = FALSE,
  .max_tries = 3,
  .display = "tidyllm_batch",
  .id_prefix = "tidyllm_gemini_req_"
)
}
\arguments{
\item{.llms}{List of LLMMessage objects (named or unnamed).}

\item{.model}{The model identifier (default: "gemini-1.5-flash").}

\item{.temperature}{Controls randomness (default: NULL, range: 0-2).}

\item{.max_output_tokens}{Maximum tokens in the response (default: NULL).}

\item{.top_p}{Nucleus sampling (default: NULL, range: 0-1).}

\item{.top_k}{Diversity in token selection (default: NULL).}

\item{.presence_penalty}{Penalizes new tokens (default: NULL, -2 to 2).}

\item{.frequency_penalty}{Penalizes frequent tokens (default: NULL, -2 to 2).}

\item{.stop_sequences}{Character vector or NULL of up to 5.}

\item{.safety_settings}{Optional list of safety settings (default: NULL).}

\item{.json_schema}{Optional schema to enforce output structure.}

\item{.grounding_threshold}{Optional grounding threshold (0-1) to enable Google Search.}

\item{.timeout}{Timeout in seconds (default: 120).}

\item{.dry_run}{If TRUE, returns the constructed request (default: FALSE).}

\item{.max_tries}{Maximum retry attempts (default: 3).}

\item{.display}{Display name for this batch (default: "tidyllm_batch").}

\item{.id_prefix}{Prefix for message IDs (default: "tidyllm_gemini_req_").}
}
\value{
Named list of LLMMessage objects with attributes \code{batch_id} and \code{json}
}
\description{
Returns a named list (same as input) with batch_id and json attributes.
}
