% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_bounds.R
\name{filter_bounds}
\alias{filter_bounds}
\title{filter_bounds a wrapper for rgee::ee$ImageCollection$filterBounds}
\usage{
filter_bounds(x, y, use_tidyee_index = FALSE, return_tidyee = TRUE)
}
\arguments{
\item{x}{tidyee object containing ee$ImageCollection or ee$ImageCollection}

\item{y}{feature to filter bounds by (sf, ee$FeatureCollection, ee$Feature, ee$Geometry)}

\item{use_tidyee_index}{filter on tidyee_index (default = F) or system_index (by default)}

\item{return_tidyee}{\code{logical} return tidyee class (default = TRUE) object or ee$ImageCollection. Faster performance if set to FALSE}
}
\value{
tidyee class or ee$ImageCollection class object with scenes filtered to bounding box of y geometry
}
\description{
filter_bounds a wrapper for rgee::ee$ImageCollection$filterBounds
}
\examples{
\dontrun{

library(tidyrgee)
library(tidyverse)
library(rgee)
rgee::ee_Initialize()

# create geometry and convert to sf
coord_tibble <- tibble::tribble(
  ~X,               ~Y,
  92.2303683692011, 20.9126490153521,
  92.2311567217866, 20.9127410439304,
  92.2287527311594, 20.9124072954926,
  92.2289221219251, 20.9197352745068,
  92.238724724534, 20.9081803233546
)
sf_ob <- sf::st_as_sf(coord_tibble, coords=c("X","Y"),crs=4326)

# load landsat
ls = ee$ImageCollection("LANDSAT/LC08/C01/T1_SR")

#create tidyee class
ls_tidy <-  as_tidyee(ls)

# filter_bounds on sf object
# return tidyee object
ls_tidy |>
  filter_bounds(sf_ob)
# return ee$ImageCollection
ls_tidy |>
  filter_bounds(sf_ob,return_tidyee = FALSE)

# filter_bounds on ee$Geometry object
# return tidyee object
ee_geom_ob <- sf_ob |> rgee::ee_as_sf()
ls_tidy |>
  filter_bounds(ee_geom_ob)


}
}
