% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tilt.R
\name{plot_tilt}
\alias{plot_tilt}
\title{Store Plots of RR Series in Folders and Produce RMSSD and pNN50 Output}
\usage{
plot_tilt(.data, folder, type)
}
\arguments{
\item{.data}{A data frame containing HRV data from previous tidyrhrv functions}

\item{folder}{A character string specifying the folder name for saved plots}

\item{type}{A character string indicating whether data are "filtered" or "original"}
}
\value{
A list of data frames containing RMSSD and pNN50 values for each dataset
}
\description{
Creates plots of heart rate variability data and saves them to specified folders
while calculating time domain metrics (RMSSD and pNN50).
}
\examples{
\donttest{
# This example requires RHRV package for HRV analysis
if (requireNamespace("RHRV", quietly = TRUE)) {
  temp_dir <- tempdir()
  
  # Generate synthetic HRV data
  hrv_data <- data.frame(
    Time = seq(0, 25, by = 0.8),
    niHR = 75 + rnorm(32, 0, 4),
    RR = 60/75 + rnorm(32, 0, 0.08)
  )
  
  write.csv(hrv_data, file.path(temp_dir, "plot_test.csv"), row.names = FALSE)
  
  # Read and prepare data
  raw_data <- read_tilt(temp_dir, read.csv)
  prepped_data <- prep_data(raw_data, "Time", "niHR", "RR")
  
  # Create plots and calculate metrics  
  plot_folder <- "test_hrv_plots"
  results <- plot_tilt(prepped_data, plot_folder, "original")
  
  print("Plots created and metrics calculated")
  
  # Clean up
  unlink(file.path(temp_dir, "plot_test.csv"))
  unlink(plot_folder, recursive = TRUE)
} else {
  message("RHRV package required for this function")
}
}
}
