% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{block_groups}
\alias{block_groups}
\title{Download a Census block groups shapefile into R, and optionally subset by county}
\usage{
block_groups(state = NULL, county = NULL, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation.  When \code{NULL} and combined with
\code{cb = TRUE}, a national dataset of block groups will be returned for
years 2019 and later.}

\item{county}{The three-digit FIPS code (string) of the county you'd like to
subset for, or a vector of FIPS codes if you desire multiple counties.
Can also be a county name or vector of names.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year; defaults to 2024}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Description from the US Census Bureau (see link for source):Standard block groups are clusters of
blocks within the same census tract that have the same first digit of
their 4-character census block number. For example, blocks 3001, 3002, 3003..., 3999 in census tract
1210.02 belong to Block Group 3. Due to boundary and feature changes that occur throughout the
decade, current block groups do not always maintain these same block number to block group
relationships. For example, block 3001 might move due to a census tract boundary change but the block
number will not change, even if it does not still fall in block group 3. However, the GEOID for that block,
identifying block group 3, would remain the same in the attribute information in the TIGER/Line Shapefiles
because block GEOIDs are always built using the decennial geographic codes.
}
\details{
Block groups delineated for the 2010 Census generally contain between 600 and 3,000 people. Most
block groups were delineated by local participants in the Census Bureau's Participant Statistical Areas
Program (PSAP). The Census Bureau delineated block groups only where a local or tribal government
declined to participate or where the Census Bureau could not identify a potential local participant.

A block group usually covers a contiguous area. Each census tract contains at least one block group and
block groups are uniquely numbered within census tract. Within the standard census geographic
hierarchy, block groups never cross county or census tract boundaries, but may cross the boundaries of
county subdivisions, places, urban areas, voting districts, congressional districts, and American Indian,
Alaska Native, and Native Hawaiian areas.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
\item \code{protocol} Character string specifying the protocol to use for downloading files. Options are "ftp" or "http" (default). If "ftp", the URL will be modified to use FTP instead of HTTPS.
\item \code{timeout} Integer specifying the timeout in seconds for download operations if protocol is "ftp". Defaults to 1800 (30 minutes) to handle large files.
}
}

\examples{
\dontrun{
library(tigris)

benton_bgs <- block_groups("Oregon", "Benton")

plot(benton_bgs$geometry)
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc.pdf}

Other general area functions: 
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{county_subdivisions}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{states}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
