% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durCalc.R
\name{durCalc}
\alias{durCalc}
\title{Filter Dataset by Date Duration}
\usage{
durCalc(df = NULL, start, end, timeunit = "day", filterlength = NA,
       filterlonger = TRUE, year = 365.25, month = 30.42)
}
\arguments{
\item{df}{Data frame containing start and end dates.}

\item{start}{Column in df for start dates or a date to use as start date.}

\item{end}{Column in df for end dates or a date to use as a end date.}

\item{timeunit}{Unit of time to be used in plots. \code{"day(s)"}, \code{"week(s)"}, \code{"month(s)"}, \code{"quarter(s)"}, \code{"semiannual"}, \code{"halfyear"},or \code{"year(s)"}.}

\item{filterlength}{A time length to use as filter.}

\item{filterlonger}{If TRUE, the function gives rows with longer durations than specified in filterlength. If FALSE, gives rows with shorter durations.}

\item{year}{Number of days to use as a year. Default is 365.25.}

\item{month}{Number of days to use as a month. Default is 30.42.}
}
\value{
A subset of original data frame with additional columns in specified time units and calendar units.
}
\description{
Calculates the duration between two dates, use it as a filter to select rows that satisfy the length criteria.
Returns the dataset with additional columns regarding the length of durations in different units.
}
\details{
Additional columns returned with the filtered rows are: length of duration in days, in specified time unit, and in calendar units, and
how much longer/shorter the durations are compared to filter length in calendar units.

If no \code{filterlength} is provided, then returns all rows with length of duration in days and calendar units.

You can use dates for \code{start} and \code{end} and provide no \code{df} to get the length of duration between the dates in calendar units. See example.
}
\examples{
### Filter people who lived longer than 85 years
durCalc(life_exp, start = "Birth", end = "Death", timeunit = "years", filterlength = 85)

### How old each person would be as of January 1, 2000 if they were alive
durCalc(life_exp, start = "Birth", end = as.Date("2000-1-1"), timeunit = "years")

### Use as unit-converter between two dates
durCalc(start = as.Date("2010-12-1"), end = as.Date("2015-4-26"), timeunit = "weeks")
}
\author{
Dahee Lee
}
\seealso{
\code{\link{durPlot}}, \code{\link{durSummary}}
}

