% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_core.R
\name{time_grid}
\alias{time_grid}
\alias{time_complete_missing}
\alias{time_grid_size}
\title{Vector date and datetime functions}
\usage{
time_grid(x, timespan = granularity(x), from = NULL, to = NULL)

time_complete_missing(x, timespan = granularity(x))

time_grid_size(x, timespan = granularity(x), from = NULL, to = NULL)
}
\arguments{
\item{x}{Time vector. \cr
E.g. a \code{Date}, \code{POSIXt}, \code{numeric} or any time-based vector.}

\item{timespan}{\link{timespan}.}

\item{from}{Start time.}

\item{to}{End time.}
}
\value{
Vectors (typically the same class as \code{x}) of varying lengths depending
on the arguments supplied.
}
\description{
These are atomic vector-based functions
of the tidy equivalents which all have a "v" suffix to denote this.
These are more geared towards programmers and allow for working with date and
datetime vectors.
}
\examples{
library(timeplyr)
library(dplyr)
library(lubridate)
library(nycflights13)
x <- unique(flights$time_hour)

# Number of missing hours
time_num_gaps(x)

# Same as above
time_grid_size(x) - length(unique(x))

# Time sequence that spans the data
length(time_grid(x)) # Automatically detects hour granularity
time_grid(x, "month")
time_grid(x, from = floor_date(min(x), "month"), to = today(),
          timespan = timespan("month"))

# Complete missing gaps in time using time_complete
y <- time_complete_missing(x, "hour")
identical(y[!y \%in\% x], time_gaps(x))

# Summarise time into higher intervals
quarters <- time_cut_width(y, "quarter")
interval_count(quarters)

}
