% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_levels.R
\name{db_access_level_list}
\alias{db_access_level_list}
\title{Get All Access Levels and Their Description}
\usage{
db_access_level_list(con, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
access levels data.frame with columns `role` and `description` and `is_default`
}
\description{
Gets an overview of roles and shows whether a role (aka access level) is
the default level for series stored without an explicitly specified access level.
}
\seealso{
Other access levels functions: 
\code{\link{change_access_level}},
\code{\link{db_access_level_create}()},
\code{\link{db_access_level_delete}()},
\code{\link{db_access_level_set_default}()},
\code{\link{db_ts_find_keys}()}
}
\concept{access levels functions}
