% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{db_collection_add_ts}
\alias{db_collection_add_ts}
\title{Bundles Keys into an Existing Collection or Adds a New Collection}
\usage{
db_collection_add_ts(
  con,
  collection_name,
  ts_keys,
  description = NULL,
  user = Sys.info()["user"],
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{collection_name}{\strong{character} name of a collection to read. Collection are bookmark lists that contain time series keys.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{description}{\strong{character} description of the collection.}

\item{user}{character name of the database user. Defaults to the user of the R session.
this is often the user for the database, too so you do not have to specify
your username explicitly if that is the case.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Collections are user specific compilations of time series keys. Similar to
a playlist in a music app, collections help to come back to a previously stored
selection of time series. This functions adds more time series to existing bundles (collections).
}
\examples{

\dontrun{
db_ts_store(con = connection, zrh_airport, schema = "schema")
db_ts_store(con = connection, kof_ts, schema = "schema")

db_collection_add_ts(
  con = connection,
  collection_name = "barometer and departures zurich",
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.departure.total",
    "ch.kof.barometer"
  ),
  schema = "schema"
)
}
}
\seealso{
Other collections functions: 
\code{\link{db_collection_delete}()},
\code{\link{db_collection_get_keys}()},
\code{\link{db_collection_get_last_update}()},
\code{\link{db_collection_list}()},
\code{\link{db_collection_remove_ts}()}
}
\concept{collections functions}
