% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{db_collection_get_last_update}
\alias{db_collection_get_last_update}
\title{Get the last update of a collection for a specific User}
\usage{
db_collection_get_last_update(
  con,
  collection_name,
  user = Sys.info()["user"],
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{collection_name}{\strong{character} name of a collection to read. Collection are bookmark lists that contain time series keys.}

\item{user}{character name of the database user. Defaults to the user of the R session.
this is often the user for the database, too so you do not have to specify
your username explicitly if that is the case.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Get the last update of a collection for a specific User
}
\examples{

\dontrun{

db_ts_store(con = connection, zrh_airport, schema = "schema")
db_ts_store(con = connection, kof_ts, schema = "schema")

db_collection_add_ts(
  con = connection,
  collection_name = "barometer and departures zurich",
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.departure.total",
    "ch.kof.barometer"
  ),
  schema = "schema"
)

db_collection_get_last_update(
  con = connection,
  collection_name = "barometer and departures zurich",
  schema = "schema"
)
}
}
\seealso{
Other collections functions: 
\code{\link{db_collection_add_ts}()},
\code{\link{db_collection_delete}()},
\code{\link{db_collection_get_keys}()},
\code{\link{db_collection_list}()},
\code{\link{db_collection_remove_ts}()}
}
\concept{collections functions}
