% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{db_dataset_create}
\alias{db_dataset_create}
\title{Create a New Dataset}
\usage{
db_dataset_create(
  con,
  set_name,
  set_description = NULL,
  set_md = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{set_name}{\strong{character} name of a dataset.}

\item{set_description}{\strong{character} description about the set. Default to NA.}

\item{set_md}{meta information data about the set. Default to NA.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
character name of the created set
}
\description{
A dataset is a family of time series that belong to the same topic. By default all series stored with `db_store_ts` belong to a default set. In order to assign them a different set, it must first be created with `db_dataset_create` after which the series may be moved with \code{\link{db_ts_assign_dataset}}.
}
\examples{

\dontrun{

db_dataset_create(
  con = connection,
  set_name = "zrh_airport_data",
  set_description = "Zurich airport arrivals and departures ",
  schema = "schema"
)
}
}
\seealso{
Other datasets functions: 
\code{\link{db_dataset_delete}()},
\code{\link{db_dataset_get_keys}()},
\code{\link{db_dataset_get_last_update}()},
\code{\link{db_dataset_list}()},
\code{\link{db_dataset_trim_history}()},
\code{\link{db_dataset_update_metadata}()},
\code{\link{db_ts_assign_dataset}()},
\code{\link{db_ts_get_dataset}()}
}
\concept{datasets functions}
