% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{db_release_create}
\alias{db_release_create}
\title{Create an Entry in the Release Calendar}
\usage{
db_release_create(
  con,
  id,
  title,
  release_date,
  datasets,
  target_year = year(release_date),
  target_period = month(release_date),
  target_frequency = 12,
  note = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{id}{Identifier for the release e.g. 'gdb_may_2020'}

\item{title}{Display title for the release}

\item{release_date}{Timestamp when the release is to occur}

\item{datasets}{\strong{character} vector of the datasets. Dataset is a group of time series.}

\item{target_year}{Year observed in the data}

\item{target_period}{Period observed in the data (e.g. month, quarter)}

\item{target_frequency}{Frequency of the data (e.g. 4 for quarterly)}

\item{note}{Additional remarks about the release.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
a status list
}
\description{
The idea of the release calendar is to set a release date for some time series that might be in the database already but should not be publicly available before a specific date, e.g., a press release. Since publishing is simply a matter of changing the access level, an update of the access levels could be triggered based on the release information in a release table. Only timeseries admins may create and modify releases.
}
\details{
\code{target_period} changes meaning depending on the frequency of the release.
e.g. period 2 for quarterly data (reference_frequency = 4) means Q2 whereas
period 2 for monthly data (frequency 12) means February
In other words: \code{target_year} and \code{target_period} mark the end of the time series
in the release.
}
\seealso{
Other calendar functions: 
\code{\link{db_dataset_get_latest_release}()},
\code{\link{db_dataset_get_next_release}()},
\code{\link{db_dataset_get_release}()},
\code{\link{db_release_cancel}()},
\code{\link{db_release_list}()},
\code{\link{db_release_update}()}
}
\concept{calendar functions}
