% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_time_series.R
\name{db_ts_read}
\alias{db_ts_read}
\title{Read Time Series From PostgreSQL into R}
\usage{
db_ts_read(
  con,
  ts_keys,
  valid_on = NULL,
  regex = FALSE,
  respect_release_date = FALSE,
  schema = "timeseries",
  chunksize = 10000
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{valid_on}{\strong{character} representation of a date in the form of 'YYYY-MM-DD'. valid_on selects the
version of a time series that is valid at the specified time.}

\item{regex}{\strong{boolean} indicating if ts_keys should be interpreted as a regular expression pattern. Defaults to FALSE.}

\item{respect_release_date}{\strong{boolean} indicating if it should the release embargo of a time series be respected. Defaults to FALSE. This option makes sense when the function is used in an API. In that sense, users do not have direct access to this function and therefore cannot simply switch parameters.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}

\item{chunksize}{set a limit of the number of time series requested in the function.}
}
\value{
list of time series. List elements vary depending on nature of time series, i.e., regular vs. irregular time series.
}
\description{
Read specific version of a time series given time series key (unique identifier) and validity. By default, this function returns the most recent version of a time series.
}
\examples{

\dontrun{
db_ts_store(con = connection, zrh_airport, schema = "schema")
db_ts_read(con = connection, ts_keys = "ch.zrh_airport.departure.total", schema = "schema")
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_store}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
