% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{zoom}
\alias{zoom}
\alias{zoomIn}
\alias{zoomOut}
\title{Zoom in/out the current visible window}
\usage{
zoomIn(id, percent = 0.5, animation = TRUE)

zoomOut(id, percent = 0.5, animation = TRUE)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{percent}{The amount to zoom in or out. Must be a number between 0 and 1.
A value of 0.5 means that after zooming out the timeline will show 50\% more content.}

\item{animation}{Whether or not to animate the zoom.}
}
\description{
Zoom in/out the current visible window
}
\examples{
\dontrun{
timevis() \%>\%
  zoomIn()

timevis() \%>\%
  zoomOut(0.3)
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    sliderInput("zoom", "Zoom by", min = 0, max = 1, value = 0.5, step = 0.1),
    checkboxInput("animate", "Animate?", TRUE),
    actionButton("zoomIn", "Zoom IN"),
    actionButton("zoomOut", "Zoom OUT")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$zoomIn, {
      zoomIn("timeline", percent = input$zoom, animation = input$animate)
    })
    observeEvent(input$zoomOut, {
      zoomOut("timeline", percent = input$zoom, animation = input$animate)
    })
  }
)
}
}
