% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_between.R
\name{find_between}
\alias{find_between}
\title{Find between a pattern}
\usage{
find_between(
  body,
  ns,
  pattern = "md:paragraph[md:text[starts-with(text(), ':::')]]",
  include = FALSE
)
}
\arguments{
\item{body}{and XML document}

\item{ns}{the namespace of the document}

\item{pattern}{an XPath expression that defines characteristics of nodes
between which you want to extract everything.}

\item{include}{if \code{TRUE}, the tags matching \code{pattern} will be included in
the output, defaults to \code{FALSE}, which only gives you the nodes in between
\code{pattern}.}
}
\value{
a nodeset
}
\description{
Helper function to find all nodes between a standard pattern. This is useful
if you want to find unnested pandoc tags.
}
\examples{
md <- glue::glue("
 h1
 ====

 ::: section

 h2
 ----

 section *text* with [a link](https://ropensci.org/)

 :::
")
x <- xml2::read_xml(commonmark::markdown_xml(md))
ns <- xml2::xml_ns_rename(xml2::xml_ns(x), d1 = "md")
res <- find_between(x, ns)
res
xml2::xml_text(res)
xml2::xml_find_all(res, ".//descendant-or-self::md:*", ns = ns)
}
