% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{tintin_pal}
\alias{tintin_pal}
\title{Tintin Colour Palettes}
\usage{
tintin_pal(
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "the_blue_lotus"
)
}
\arguments{
\item{alpha}{The alpha transparency, a number in \verb{[0,1]}, see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in \verb{[0,1]} at which the color map begins.}

\item{end}{The (corrected) hue in \verb{[0,1]} at which the color map ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{option}{A character string indicating the color map option to use.
Options are available:
\itemize{
\item "Tintin in the Land of the Soviets"
\item "Tintin in the Congo"
\item "Tintin in America"
\item "Cigars of the Pharaoh"
\item "The Blue Lotus" (Standard)
\item "The Broken Ear"
\item "The Black Island"
\item "King Ottokar's Sceptre"
\item "The Crab with the Golden Claws"
\item "The Shooting Star"
\item "The Secret of the Unicorn"
\item "Red Rackham's Treasure"
\item "The Seven Crystal Balls"
\item "Prisoners of the Sun"
\item "Land of Black Gold"
\item "Destination Moon"
\item "Explorers on the Moon"
\item "The Calculus Affair"
\item "The Red Sea Sharks"
\item "Tintin in Tibet"
\item "The Castafiore Emerald"
\item "Flight 714 to Sydney"
\item "Tintin and the Picaros"
\item "Tintin and Alph-Art"
}}
}
\value{
A function that takes an integer argument and returns a \code{character} vector of colors.
}
\description{
A wrapper function around \code{Tintin_clrs} to
turn it into a palette function compatible with
\code{\link[ggplot2]{discrete_scale}}.
}
\details{
See \code{Tintin_clrs} for more information on the color palettes.
}
\examples{
tintin_pal()

scales::show_col(tintin_pal()(5))

}
