% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{over_map}
\alias{over_map}
\title{Map a function over a list lens}
\usage{
over_map(d, l, f)
}
\arguments{
\item{d}{The data structure to modify}

\item{l}{The list-returning lens to apply}

\item{f}{The function to apply to each element of the list}
}
\value{
The modified data structure
}
\description{
Apply a function to each element of a list returned by a lens. Using \code{over}
in such cases would require a "lifted" function, which is often unergonomic.
}
\examples{
d <- list(list(a = 1, b = 2), list(a = 4, b = 9))
l <- map_l(index_l("a"))
over_map(d, l, sqrt)
}
