% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_05_kRp.corpus-class_freq.analysis.R
\docType{methods}
\name{freq.analysis,kRp.corpus-method}
\alias{freq.analysis,kRp.corpus-method}
\title{Apply freq.analysis() to all texts in kRp.corpus objects}
\usage{
\S4method{freq.analysis}{kRp.corpus}(txt.file, ...)
}
\arguments{
\item{txt.file}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{...}{options to pass through to \code{\link[koRpus:freq.analysis]{freq.analysis}}.}
}
\value{
An object of the same class as \code{txt.file}.
}
\description{
This method calls \code{\link[koRpus:freq.analysis]{freq.analysis}} on all tagged text objects
inside the given \code{txt.file} object.
}
\details{
If \code{corp.freq} was not specified but a valid object of class \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}}
is found in the \code{freq} slot of \code{txt.file},
      it is used automatically. That is the case if you called
\code{\link[tm.plugin.koRpus:read.corp.custom]{read.corp.custom}} on the object previously.
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Edwards"
    ),
    hierarchy=list(
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  myCorpus <- read.corp.custom(myCorpus)
  myCorpus <- freq.analysis(myCorpus)
  corpusFreq(myCorpus)
} else {}
}
