% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statisticaltests.R
\name{tmodAUC}
\alias{tmodAUC}
\title{Calculate AUC}
\usage{
tmodAUC(
  l,
  ranks,
  modules = NULL,
  stat = "AUC",
  recalculate.ranks = TRUE,
  filter = FALSE,
  mset = "all"
)
}
\arguments{
\item{l}{List of gene names corresponding to rows from the ranks matrix}

\item{ranks}{a matrix with ranks, where columns correspond to samples
and rows to genes from the l list}

\item{modules}{optional list of modules for which to make the test}

\item{stat}{Which statistics to generate. Default: AUC}

\item{recalculate.ranks}{Filtering and removing duplicates will also
remove ranks, so that they should be recalculated. Use FALSE if you don't
want this behavior. If unsure, stay with TRUE}

\item{filter}{Remove gene names which have no module assignments}

\item{mset}{Which module set to use. "LI", "DC" or "all" (default: "all")}
}
\value{
A matrix with the same number of columns as "ranks" and as many
rows as there were modules to be tested.
}
\description{
Calculate AUC
}
\details{
tmodAUC calculates the AUC and U statistics. The main purpose of this
function is the use in randomization tests. While tmodCERNOtest and
tmodUtest both calculate, for each module, the enrichment in a single
sorted list of genes, tmodAUC takes any number of such sorted lists. Or,
actually, sortings -- vectors with ranks of the genes in each replicate.

Note that the input for this function
is different from tmodUtest and related functions: the ordering of l
and the matrix ranks does not matter, as long as the matrix ranks
contains the actual rankings. Each column in the ranks matrix is treated as
a separate sample.

Also, the `nodups` parameter which is available (and TRUE by default) for 
other tests cannot be used here. This means that the AUCs calculated here
might be slightly different from the AUCs calculated with default
parameters in tests such as the [tmodCERNOtest()]. Use `nodups=FALSE`
with [tmodCERNOtest()] to obtain identical results as with `tmodAUC`.
}
\examples{
data(tmod)
l <- tmod_ids(tmod)
ranks <- 1:length(l)
res <- tmodAUC(l, ranks)
head(res)
}
\seealso{
tmod-package
}
