% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-proxy.R
\name{grid_proxy_add_row}
\alias{grid_proxy_add_row}
\title{Add rows to an existent datagrid}
\usage{
grid_proxy_add_row(proxy, data)
}
\arguments{
\item{proxy}{A \code{\link[=datagrid_proxy]{datagrid_proxy()}} or \code{outputId} of the grid.}

\item{data}{\code{data.frame} to append in the grid.}
}
\value{
A \code{datagrid_proxy} object.
}
\description{
Add rows to an existent datagrid
}
\examples{
library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("Append row to grid"),
  datagridOutput("grid"),
  actionButton(
    inputId = "add",
    label = "Add row",
    class = "btn-block"
  )
)

server <- function(input, output, session) {

  dat <- data.frame(
    character = month.name,
    select = month.name,
    checkbox = month.abb,
    radio = month.name,
    password = month.name
  )

  output$grid <- renderDatagrid({
    datagrid(rolling_stones_50[1, ])
  })

  value <- reactiveVal(1)
  observeEvent(input$add, {
    row <- value() + 1
    grid_proxy_add_row(
      proxy = "grid",
      data = rolling_stones_50[row, ]
    )
    value(row)
  })

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
Other datagrid proxy methods: 
\code{\link{datagrid_proxy}()},
\code{\link{grid_proxy_delete_row}()}
}
\concept{datagrid proxy methods}
