% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/todor.R
\name{todor}
\alias{todor}
\title{TODOR
This package helps you to find all code rows in your code with places
to be filled in the future.}
\usage{
todor(
  todo_types = NULL,
  search_path = getwd(),
  file = NULL,
  output = "markers"
)
}
\arguments{
\item{todo_types}{vector with character describing types of elements to
detect. If NULL default items will be used.}

\item{search_path}{vector with paths that contains comments you are looking
for.}

\item{file}{character with path to file. If not NULL the search_path will be
ignored.}

\item{output}{what form should the output take? "markers" (default) creates a
marker for each TODO and lists them in the "Markers" Rstudio pane. "text"
coverts the TODO list to markdown syntax}
}
\description{
Called on project that are not R packages. Checks all places in the code
which require amendents as specified in \code{todo_types} on R and r files.
It triggers rstudio markers to appear.
}
\details{
There are several options that let you control TODOr behaviour:

\code{todor_rmd} - when set to TRUE it searches also through Rmd files
(default TRUE).

\code{todor_rnw} - when set to TRUE it searches also through Rnw files
(default FALSE).

\code{todor_rhtml} - when set to TRUE it searches also through Rhtml files
(default FALSE).

\code{todor_exclude_packrat} when set to FALSE, all files in the "packrat"
directory are excluded (default TRUE).

\code{todor_exclude_r} when TRUE, it ignores R and r files (default FALSE)

\code{todor_patterns} must be vector. Contains all the names of patterns to
be detected. Default are: "FIXME", "TODO", "CHANGED", "IDEA", "HACK", "NOTE",
"REVIEW", "BUG", "QUESTION", "COMBAK", "TEMP".
}
