% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{getSegments}
\alias{getSegments}
\title{Get Segments}
\usage{
getSegments(
  data,
  coord.type = c("coordinate", "distance", "both"),
  group = FALSE
)
}
\arguments{
\item{data}{data.table returned from function tdtr()}

\item{coord.type}{return actual coordinates, relative distance, or both (see
Details)}

\item{group}{separate by group, default is FALSE}
}
\value{
data.table with segments only, containing information about the start
and end locations, start and end time and distance covered by the segment
}
\description{
Extract segment info from the segmented data.table.
}
\details{
Segment location information can be either in lat/lon coordinates, or
expressed in terms of distance for a more anonymous presentation of small
trajectories. (Full anonymity is not guaranteed as sufficiently long
trajectories with small error parameters can provide enough data to match
against a map.)
}
\examples{
df <- data.frame(entity_id = rep(1, 12),
   timestamp = c(1, 2, 4, 10, 14, 18, 20, 21, 24, 25, 28, 29),
   lon = c(5.1299311, 5.129979, 5.129597, 5.130028, 5.130555, 5.131083,
           5.132101, 5.132704, 5.133326, 5.133904, 5.134746, 5.135613),
   lat = c(52.092839, 52.092827, 52.092571, 52.092292, 52.092076, 52.091821,
           52.091420, 52.091219, 52.091343, 52.091651, 52.092138, 52.092698))
# First generate segments
res30 <- tdtr(df,
     group_col = NULL,
     max_error = 30)
# Then extract a data.table of segments
getSegments(res30)

# Calculating distance instead of coordinates
segs <- getSegments(res30, coord.type = "distance")
segs
plot(c(0, 700), c(0, 200), col = "white",
     xlab = "East-West distance",
     ylab = "North-South distance")
with(segs,
     segments(seg_start_lon_dist, seg_start_lat_dist,
      seg_end_lon_dist, seg_end_lat_dist))
}
