% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topoProfile.R
\name{topoProfile}
\alias{topoProfile}
\title{Elevation profiles of topographic paths}
\usage{
topoProfile(
  DEM,
  topoPaths,
  pts = 100,
  type = "base",
  singlePlot = FALSE,
  rows = NULL,
  cols = NULL,
  limits = NULL,
  legendx = "bottomright"
)
}
\arguments{
\item{DEM}{A RasterLayer for digital elevation model (DEM) data.}

\item{topoPaths}{A SpatialLines object containing the topographic paths to be plotted.}

\item{pts}{numeric (default = 100). The number of elevation points to plot along each path.}

\item{type}{character (default = "base"). Type of plotting: "base" or "plotly".}

\item{singlePlot}{logical (default = FALSE). If TRUE, profiles will be drawn on a single plot.}

\item{rows}{numeric (optional). Number of rows for plot layout (if singlePlot = FALSE)}

\item{cols}{numeric (optional). Number of columns for plot layout (if singlePlot = FALSE)}

\item{limits}{numeric vector (optional). A vector with the lower and upper limits for the y-axis (elevation).}

\item{legendx}{character (default = "bottomright"). Position for the legend.}
}
\value{
Plot of elevation profiles
}
\description{
Plots topographic cross sections (elevation profiles) of topographic paths
}
\details{
For the type argument, choosing "base" will use base R plotting, and choosing "plotly" will draw an interactive plot with the plotly package.

If rows, cols, or limits are not specified, the most even arrangement will be detected and used.
}
\examples{
xy <- matrix(ncol = 2, byrow = TRUE,
   c(-119.5566, 37.7247,
     -119.4718, 37.7608))
YosPaths <- topoDist(Yosemite$DEM, xy, paths = TRUE)
topoProfile(Yosemite$DEM, topoPaths = YosPaths)
}
