#include <R.h>
#include <Rdefines.h>
#include <Rinternals.h>
#include <R_ext/Rdynload.h>
#include <R_ext/Visibility.h>

#include <stdint.h>

#include "stack.h"
#include "fw.h"
#include "dag.h"
#include "scc.h"

SEXP C_fdag(SEXP from,SEXP to,SEXP C){
  uint32_t n=length(from);
  if(length(to)!=length(from)) error("Mismatch!");
  uint32_t c=asInteger(C);
  //Here we assume that R-land makes it >0
  uint32_t *f=(uint32_t*)INTEGER(from);
  uint32_t *t=(uint32_t*)INTEGER(to);
  for(uint32_t e=0;e<n;e++){
    if((f[e]<1)||(t[e]<1)) error("Vote for <1");
    if((f[e]>c)||(t[e]>c)) error("Vote out of range or NA");
  }
  struct dag *D=new_dag(c);

  SEXP Ans=PROTECT(allocVector(VECSXP,3)),
    Accepted=PROTECT(allocVector(LGLSXP,n)),
    Graph=PROTECT(allocVector(LGLSXP,c*c)),
    Order=PROTECT(allocVector(INTSXP,c));

  int *acp=INTEGER(Accepted);
  int *gr=INTEGER(Graph);
  int *ord=INTEGER(Order);

  for(uint32_t e=0;e<n;e++)
    acp[e]=add_edge(D,f[e]-1,t[e]-1);
  
  for(uint32_t e=0;e<c*c;e++)
    gr[e]=D->graph[e];

  for(uint32_t e=0;e<c;e++)
    ord[D->n2e[e]]=e+1;
  
  free_dag(D);
  
  SET_VECTOR_ELT(Ans,0,Accepted);
  SET_VECTOR_ELT(Ans,1,Graph);
  SET_VECTOR_ELT(Ans,2,Order);
  UNPROTECT(4);
  return(Ans);
}

SEXP C_fw(SEXP mtx){
  uint32_t c=(uint32_t)sqrt((double)length(mtx));
  if(c*c!=length(mtx)) error("Invalid input");

  SEXP Ans=PROTECT(allocVector(REALSXP,c*c));
  double *t=REAL(Ans);
  double *x=REAL(mtx);
  floyd_warshall(x,c,t);
  UNPROTECT(1);
  return(Ans);
}

SEXP C_scc(SEXP mtx){
  uint32_t c=(uint32_t)sqrt((double)length(mtx));
  if(c*c!=length(mtx)) error("Invalid input");

  uint32_t *g=(uint32_t*)INTEGER(mtx);

  SEXP Ans=PROTECT(allocVector(INTSXP,c));
  int *ans=INTEGER(Ans);
  tarjan(g,c,ans);

  UNPROTECT(1);
  return(Ans);
}

SEXP C_tc(SEXP mtx){
  uint32_t c=(uint32_t)sqrt((double)length(mtx));
  if(c*c!=length(mtx)) error("Invalid input");

  SEXP Ans=PROTECT(allocVector(LGLSXP,c*c));
  uint32_t *t=(uint32_t*)INTEGER(Ans);
  uint32_t *x=(uint32_t*)INTEGER(mtx);
  hsu(x,c,t);
  UNPROTECT(1);
  return(Ans);
}

#define CALLDEF(name,n) {#name,(DL_FUNC)&name,n}
static const R_CallMethodDef R_CallDef[]={
  CALLDEF(C_fdag,3),
  CALLDEF(C_fw,1),
  CALLDEF(C_scc,1),
  CALLDEF(C_tc,1),
  {NULL,NULL,0}
};

void attribute_visible R_init_toporanga(DllInfo *dll){
  R_registerRoutines(dll,NULL,R_CallDef,NULL,NULL);
  R_useDynamicSymbols(dll,FALSE);
  R_forceSymbols(dll,TRUE);
}  
