% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops-boxes.R
\name{box_convert}
\alias{box_convert}
\title{Box Convert}
\usage{
box_convert(boxes, in_fmt, out_fmt)
}
\arguments{
\item{boxes}{(Tensor[N, 4]): boxes which will be converted.}

\item{in_fmt}{(str): Input format of given boxes. Supported formats are ['xyxy', 'xywh', 'cxcywh'].}

\item{out_fmt}{(str): Output format of given boxes. Supported formats are ['xyxy', 'xywh', 'cxcywh']}
}
\value{
boxes (Tensor[N, 4]): Boxes into converted format.
}
\description{
Converts boxes from given in_fmt to out_fmt.
}
\details{
Supported in_fmt and out_fmt are:
\itemize{
\item 'xyxy': boxes are represented via corners,
\itemize{
\item \eqn{x_{min}, y_{min}} being top left and
\item \eqn{x_{max}, y_{max}} being bottom right.
}
\item 'xywh' : boxes are represented via corner, width and height,
\itemize{
\item \eqn{x_{min}, y_{min}} being top left,
\item w, h being width and height.
}
\item 'cxcywh' : boxes are represented via centre, width and height,
\itemize{
\item \eqn{c_x, c_y} being center of box,
\item w, h  being width and height.
}
}
}
