% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{catf}
\alias{catf}
\title{Format and Print}
\usage{
catf(fmt, ..., file = "", append = FALSE, fill = FALSE, labels = NULL)
}
\arguments{
\item{fmt}{A character vector of format strings, each of up to 8192 bytes.}

\item{...}{Up to 100 values to be passed into \code{fmt}. Only logical, integer, real and character vectors are supported, but some coercion will be done: see the Details section of \code{\link[base:sprintf]{base::sprintf()}}.}

\item{file}{A \link{connection}, or a character string naming the file to print to. If \code{""} (the default), \code{cat2} prints to the standard output connection, the console unless redirected by \link{sink}.}

\item{append}{logical. Only used if the argument \code{file} is the name of file (and not a connection or \code{"|cmd"}). If \code{TRUE} output will be appended to \code{file}; otherwise, it will overwrite the contents of \code{file}.}

\item{fill}{a logical or (positive) numeric controlling how the output is broken into successive lines. If \code{FALSE} (default), only newlines created explicitly by \code{"\\n"} are printed. Otherwise, the output is broken into lines with print width equal to the option \code{width} if \code{fill} is \code{TRUE}, or the value of \code{fill} if this is numeric. Linefeeds are only inserted \emph{between} elements, strings wider than \code{fill} are not wrapped. Non-positive \code{fill} values are ignored, with a warning.}

\item{labels}{character vector of labels for the lines printed. Ignored if \code{fill} is \code{FALSE}.}
}
\value{
No return value, called for side effects
}
\description{
Same as \code{cat(sprintf(fmt, ...))}
}
\examples{
catf("A\%dB\%sC", 2, "asdf") # prints "A2BasdfC"
}
\keyword{base}
