% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_ladders_shiny_app.R
\name{fix_ladders_interactive}
\alias{fix_ladders_interactive}
\title{Fix ladders interactively}
\usage{
fix_ladders_interactive(fragment_trace_list)
}
\arguments{
\item{fragment_trace_list}{A list of fragments objects containing fragment data}
}
\value{
interactive shiny app for fixing ladders
}
\description{
An app for fixing ladders
}
\details{
This function helps you fix ladders that are incorrectly assigned. Run \code{fix_ladders_interactive()}
and provide output from \code{find_ladders}. In the app, for each sample, click on
line for the incorrect ladder size and drag it to the correct peak.

Once you are satisfied with the ladders for all the broken samples, click the download
button to generate a file that has the ladder correction data. Read this file
back into R using readRDS, then use \code{\link[=fix_ladders_manual]{fix_ladders_manual()}} and supply the ladder
correction data as \code{ladder_df_list}. This allows the manually corrected data to
be saved and used within a script so that the correct does not need to be done
every time. An example of what you would need to do:

ladder_df_list <- readRDS('path/to/exported/data.rds')
test_ladders_fixed <- fix_ladders_manual(test_ladders_broken, ladder_df_list)
}
\examples{

# to create an example, lets brake one of the ladders
brake_ladder_list <-  list(
   "20230413_A08.fsa" = data.frame(
     size = c(35, 50, 75, 100, 139, 150, 160, 200, 250, 300, 340, 350, 400, 450, 490, 500),
     scan = c(1544, 1621, 1850, 1912, 2143, 2201, 2261, 2506, 2805, 3135, 3380, 3442, 3760, 
              4050, 4284, 4332)
   )
 )

fsa_list <- lapply(cell_line_fsa_list, function(x) x$clone())
# import data with read_fsa() to generate an equivalent list to cell_line_fsa_list
test_fragments <- trace(fsa_list, ladder_df_list = brake_ladder_list)

if (interactive()) {
  fix_ladders_interactive(test_fragments)
}

# once you have corrected your ladders in the app, 
# export the data for incorporation into the script.
# You can then re-import the data and fix ladders as described in the help details.

}
\seealso{
\code{\link[=fix_ladders_manual]{fix_ladders_manual()}}, \code{\link[=find_ladders]{find_ladders()}}
}
