% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reading.R, R/zzz_aliases.R
\name{read_directory}
\alias{read_directory}
\alias{readDirectory}
\title{Read all supported container files from a supplied directory}
\usage{
read_directory(
  directory,
  aggregate = FALSE,
  table = "gps_data",
  timezone = "",
  session_threshold = 2,
  smooth_elevation_gain = TRUE,
  correct_distances = FALSE,
  country = NULL,
  mask = TRUE,
  from_distances = NULL,
  speedunit = list(tcx = "m_per_s", gpx = "km_per_h", db3 = "km_per_h", json =
    "km_per_h"),
  distanceunit = list(tcx = "m", gpx = "km", db3 = "km", json = "km"),
  sport = NULL,
  lgap = 30,
  lskip = 5,
  m = 11,
  silent = FALSE,
  parallel = FALSE,
  verbose = TRUE
)

readDirectory(
  directory,
  aggregate = FALSE,
  table = "gps_data",
  timezone = "",
  session_threshold = 2,
  smooth_elevation_gain = TRUE,
  correct_distances = FALSE,
  country = NULL,
  mask = TRUE,
  from_distances = NULL,
  speedunit = list(tcx = "m_per_s", gpx = "km_per_h", db3 = "km_per_h", json =
    "km_per_h"),
  distanceunit = list(tcx = "m", gpx = "km", db3 = "km", json = "km"),
  sport = NULL,
  lgap = 30,
  lskip = 5,
  m = 11,
  silent = FALSE,
  parallel = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{directory}{The path to the directory.}

\item{aggregate}{Logical. Aggregate data from different files to
the same session if observations are less then
\code{session_threshold} hours apart? Alternatively, data from
different files is stored in different sessions.}

\item{table}{The name of the table in the database for db3 files.}

\item{timezone}{The timezone of the observations as passed on to
\code{\link[base]{as.POSIXct}}.  Ignored for JSON files.}

\item{session_threshold}{The threshold in hours for the time
difference between consecutive timestamps above which they are
considered to belong to different training sessions.}

\item{smooth_elevation_gain}{Logical. Should the elevation gain be
smoothed before computing elevation gain? Default
is \code{TRUE}.}

\item{correct_distances}{Logical. Should the distances be corrected
for elevation? Default is \code{FALSE}.}

\item{country}{ISO3 country code for downloading altitude data. If
\code{NULL}, country is derived from longitude and latitude}

\item{mask}{Logical. Passed on to
\code{\link[raster]{getData}}. Should only the altitudes for
the specified \code{country} be extracted (\code{TRUE}) or also
those for the neighbouring countries (\code{FALSE})?}

\item{from_distances}{Logical. Should the speeds be calculated from
the distance recordings instead of taken from the speed
recordings directly. Defaults to \code{TRUE} for tcx and Golden
Cheetah's json files and to \code{FALSE} for db3 files.}

\item{speedunit}{Character string indicating the measurement unit
of the speeds in the container file to be converted into meters
per second. Default is \code{m_per_s} for tcx files and
\code{km_per_h} for db3 and Golden Cheetah's json files. See
Details.}

\item{distanceunit}{Character string indicating the measurement
unit of the distance in the container file to be converted into
meters. Default is \code{m} for tcx files and \code{km} for db3
and Golden Cheetah's json files. See Details.}

\item{sport}{What sport do the files in \code{directory} correspond
to? Either \code{'cycling'}, \code{'running'},
\code{'swimming'} or \code{NULL} (default), in which case an
attempt is made to extract the sport from each file in
\code{directory}.}

\item{lgap}{Time in seconds corresponding to the minimal sampling rate.}

\item{lskip}{Time in seconds between the last observation before a small break
and the first imputed speed or the last imputed speed and the first
observation after a small break.}

\item{m}{Number of imputed observations in each small break.}

\item{silent}{Logical. Should warnings be generated if any of the
sanity checks on the data are triggered?}

\item{parallel}{Logical. Should reading be carried out in parallel?
If \code{TRUE} reading is performed in parallel using the
backend provided to \pkg{foreach}. Default is
\code{FALSE}.}

\item{verbose}{Logical. Should progress reports be printed?}
}
\value{
An object of class \code{\link{trackeRdata}}.
}
\description{
Read all supported container files from a supplied directory
}
\details{
Available options for \code{speedunit} currently are
\code{km_per_h}, \code{m_per_s}, \code{mi_per_h},
\code{ft_per_min} and \code{ft_per_s}.  Available options for
\code{distanceunit} currently are \code{km}, \code{m},
\code{mi} and \code{ft}.

If \code{aggregate = TRUE}, then if \code{sport = NULL} the
sport in all sessions is determined by the first file read with
a sport specification; else if \code{sport} is one of the other
valid options it determines the sport for all sessions.
}
\examples{
\dontrun{
filepath <- system.file("extdata/gpx", package = "trackeR")
gpx_files <- read_directory(filepath)
}

}
\seealso{
\code{\link{trackeRdata}}, \code{\link{readTCX}}, \code{\link{readDB3}}, \code{\link{readJSON}}
}
