% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_distance_to.R
\name{track_distance_to}
\alias{track_distance_to}
\title{Track distance to location/s}
\usage{
track_distance_to(x, y, to_x, to_y)
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}

\item{to_x}{longitude vector of \emph{to} location/s}

\item{to_y}{latitude vector of \emph{to} locations/s}
}
\value{
a numeric vector of distance-to values in metres
}
\description{
Calculate geodesic distance to a location or locations based on longitude,
latitude (from) input vectors and longitude, latitude (to) input vectors. The
unit of distance is metres. The \emph{to} values may be a single value or
individual to each \emph{from} location.
}
\details{
No missing values are required as padding, but input data with \code{NA}s will incur an
\code{NA} in the output.

To use this on multiple track ids, use a grouped data frame with tidyverse code like
\code{data \%>\% group_by(id) \%>\% mutate(distance = track_distance_to(lon, lat, to_lon, to_lat))}
}
\examples{
track_distance_to(trips0$x, trips0$y, to_x = 147, to_y = -42)[1:10]
}
