% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_bootstrap_moments.R
\name{trait_summarise_boot_moments}
\alias{trait_summarise_boot_moments}
\title{Summarise Bootstrap traits}
\usage{
trait_summarise_boot_moments(
  bootstrap_moments,
  parametric = TRUE,
  sd_mult = 1,
  ci = 0.95
)
}
\arguments{
\item{bootstrap_moments}{trait moments from trait_np_bootstrap or
trait_parametric_bootstrap}

\item{parametric}{logical; default is TRUE.
Should Confidence Intervals be calculated parametrically
(using the mean and SD) or nonparametrically (using quantiles).}

\item{sd_mult}{Number of standard deviations around each moment,
defaults to one}

\item{ci}{Desired confidence level for use when parametric is false.
Defaults to 0.95.}
}
\value{
tibble with the grouping variables and the mean of each moment
(+/- sd_mult * SD)
}
\description{
Summarizes the mean and confidence interval for each
trait moment.
}
\examples{
library(dplyr)
data(community)
data(trait)

# Filter community data to make example faster
community <- community |>
  filter(PlotID \%in\% c("A", "B"))

filled_traits <- trait_fill(
  comm = community,
  traits = trait,
  scale_hierarchy = c("Site", "PlotID"),
  taxon_col = "Taxon", value_col = "Value",
  trait_col = "Trait", abundance_col = "Cover"
)

# Note that more replicates and a greater sample size are advisable
# Here we set them low to make the example run quickly
boot_traits <- trait_np_bootstrap(filled_traits,
  nrep = 20,
  sample_size = 100
)

trait_summarise_boot_moments(boot_traits)
}
