% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupProfiles.R
\name{GroupProfiles}
\alias{GroupProfiles}
\title{Profiles of each group}
\usage{
GroupProfiles(sol, Y, A, X)
}
\arguments{
\item{sol}{Trajectory's object. A object of type trajectory.}

\item{Y}{Matrix. A matrix containing the variables in the model.}

\item{A}{Matrix. A matrix containing the time variable data.}

\item{X}{Matrix. An optional matrix that modify the probability of belong to group.
By default its value is a matrix with one column  with value 1.}
}
\value{
A table of real.
}
\description{
\code{GroupProfiles} calculate the profile of a group regarding covariate. It is a
cross tabulation of individual level trajectory group assignments with
individual level characteristic that might be associated with trajectory
group membership.
}
\examples{
data <- read.csv(system.file("extdata", "CNORM2gr.csv", package = "trajeR"))
data <- as.matrix(data)
sol <- trajeR(
  Y = data[, 2:6], A = data[, 7:11], Risk = data[, 12],
  degre = c(2, 2), Model = "CNORM", Method = "L"
)
GroupProfiles(sol, Y = data[, 2:6], A = data[, 7:11], X = data[, 12])
}
