% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3D.R
\name{Traj3DSmoothSG}
\alias{Traj3DSmoothSG}
\title{Smooth a 3D trajectory using a Savitzky-Golay filter}
\usage{
Traj3DSmoothSG(trj3d, p = 3, n = p + 3 - p\%\%2, ...)
}
\arguments{
\item{trj3d}{The 3=dimensional trajectory to be smoothed.}

\item{p}{polynomial order (passed to \code{\link[signal]{sgolayfilt}}).}

\item{n}{Filter length (or window size), must be an odd number.  Passed to
\code{\link[signal]{sgolayfilt}}.}

\item{...}{Additional arguments are passed to
\code{\link[signal]{sgolayfilt}}.}
}
\value{
A new trajectory which is a smoothed version of the input trajectory.
}
\description{
Smooths a 3-dimensional trajectory using a Savitzky-Golay smoothing filter.
}
\details{
Consider carefully the effects of smoothing a trajectory with temporal gaps
in the data. If the smoothed trajectory is used to derive speed and/or
acceleration, it may be advisable to fill in the gaps before smoothing,
possibly by calling \code{Traj3DResampleTime}.
}
\seealso{
\code{\link{Traj3DFromCoords}}, \code{\link[signal]{sgolayfilt}}, \code{\link{TrajSmoothSG}}
}
