% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef<-.tramME}
\alias{coef<-.tramME}
\title{Set coefficients of a tramME model.}
\usage{
\method{coef}{tramME}(object) <- value
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{value}{Numeric vector of new coefficient values.}
}
\value{
A \code{tramME} object with the new coefficient values.
}
\description{
Sets the whole vector of fixed-effects coefficients of a tramME model.
The parameters of the baseline transformation function should respect the
restrictions of the parameter space. This is checked before setting the new
parameter values provided that the parameters for the variance components has
already been set.
If the model contains fixed coefficient parameters, the input should also respect
that.
When called on a fitted tram object, the function sets it to unfitted and removes
all parts that come from the estimation.
}
\examples{
data("sleepstudy", package = "lme4")
mod <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy, nofit = TRUE)
coef(mod) <- c(-1, 0.5, 1)
}
