% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{schwartz}
\alias{schwartz}
\title{eGFR by bedside Schwartz formula}
\usage{
schwartz(creat, height, units = "SI")
}
\arguments{
\item{creat}{numeric vector of creatinine levels in µmol/l (or mg/dl if units = "US")}

\item{height}{numeric vector of heights in cm}

\item{units}{non-vectorised optional parameter for creatinine unit ("SI" for µmol/l (default), "US" for mg/dl)}
}
\value{
numeric vector of eGFR values
}
\description{
A vectorised formula to calculate estimate glomerular filtration rate in children using the bedside Schwartz formula. By default this uses
serum creatinine in µmol/l but this can be changed to mg/dl by setting the optional units parameter to "US".
}
\details{
Reference: Schwartz GJ, Munoz A, Schneider MF et al. New equations to estimate GFR in children
with CKD. J Am Soc Nephrol 2009; 20(3):629-637.
}
\examples{
# calculate using creatinine in µmol/l
schwartz(creat = 64, height = 101)

# calculate using mg/dl
schwartz(creat = 0.7, height = 101, units = "US")
}
