% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nankivell_walser.R
\name{walser_US}
\alias{walser_US}
\title{eGFR using the Walser formula (US units)}
\usage{
walser_US(SCr, Age, Weight, Sex)
}
\arguments{
\item{SCr}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{Age}{numeric vector of patient ages in years}

\item{Weight}{numeric vector of patient weights in kilograms}

\item{Sex}{character vector of sex ("F" for female, "M" for male)}
}
\value{
numeric vectors of eGFR values
}
\description{
A wrapper function for the walser() vectorised function to calculate eGFR using the Walser formula,
using serum creatinine in mg/dl. It has not been possible to run automated tests to confirm the
accuracy of this function, so please use with caution.
}
\details{
Reference: Walser M, Drew HH, Guldan JL. Prediction of glomerular filtration rate in advanced
chronic renal failure. Kidney International 1993; 44:2245-1148.
}
\examples{
walser_US(SCr = 1.33, Age = 74, Weight = 65, Sex = "M") # 56.3
}
