% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{leadx-lagx}
\alias{leadx-lagx}
\alias{lagx}
\alias{leadx}
\title{Compute lagged or leading values}
\usage{
lagx(x, n = 1L, fill = NA)

leadx(x, n = 1L, fill = NA)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{n}{\verb{[positive integer(1): 1L]}

Value indicating the number of positions to lead or lag by.}

\item{fill}{\verb{[numeric or function: NA]}

Numeric value(s) or function used to fill observations.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}

Find the "previous" (\code{lagx()}) or "next" (\code{leadx()}) values in a vector.
Useful for comparing values behind of or ahead of the current values.
}
\details{
This functions has been taken and modified from the \code{dplyr} package,
however, to reduce dependencies they are not imported.
}
\examples{

x <- c(5,3,2,2,5)
lagx(x)
lagx(x, fill = mean)
lagx(x, fill = fill_nocb)

leadx(x)
leadx(x, fill = fill_locf)
}
