% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroidAngles.R
\name{imbalSubdiv_A}
\alias{imbalSubdiv_A}
\alias{imbalSubdiv_alpha}
\alias{angle3dVec}
\title{Calculation of the centroid angles}
\usage{
imbalSubdiv_A(x, p, v, centr_v, centr_v_weight, edge_weight)

imbalSubdiv_alpha(x, p, v, centr_v, centr_v_weight, edge_weight)

angle3dVec(a, b)
}
\arguments{
\item{x}{Numeric value \eqn{\in [0,1]} which indicates where on the 
edge \eqn{(p,v)} the subdivision takes place: 
\eqn{v+x \cdot (p-v)}{v+x*(p-v)}.}

\item{p}{Numeric vector of size 3 (3D coordinates of parent node \eqn{p}).}

\item{v}{Numeric vector of size 3 (3D coordinates of node \eqn{v}).}

\item{centr_v}{Numeric vector of size 3 (3D coordinates of the centroid of
the pending subtree of node \eqn{v}).}

\item{centr_v_weight}{Numeric value >=0 (weight of the pending subtree of 
node \eqn{v}).}

\item{edge_weight}{Numeric value >=0 (weight of the edge \eqn{(p,v)}).}

\item{a}{Numeric vector of size 3 (e.g., 3D coordinates).}

\item{b}{Numeric vector of size 3 (e.g., 3D coordinates).}
}
\value{
\code{imbalSubdiv_A} Numeric value \eqn{\in [0,\pi]} (higher values
indicate a higher degree of asymmetry).

\code{imbalSubdiv_alpha} Numeric value \eqn{\in [0,\pi/2]} 
(higher values indicate a higher degree of asymmetry).

\code{angle3dVec} Numeric value in \eqn{[0,\pi]}.
}
\description{
\code{imbalSubdiv_A} - Calculates the node imbalance value "centroid
angle" of a vertex which subdivides the edge \eqn{(p,v)} at 
\eqn{v+x \cdot (p-v)}{v+x*(p-v)} with \eqn{x \in [0,1]}. For example, 
we can obtain the node imbalance value of \eqn{v} if \eqn{x=0}, and 
\eqn{x=0.5} would indicate a subdividing node exactly in the middle of 
\eqn{v} and \eqn{p}. \cr
Attention: If \eqn{x=1}, this function will not calculate the node imbalance
value of \eqn{p} with respect to its incoming edge but with respect to the
edge \eqn{(p,v)} itself. This enables us to estimate the 
node imbalance integrals over the entire edge length.

\code{imbalSubdiv_alpha} - Calculates the node imbalance value "minimal
centroid angle" of a vertex which subdivides the edge \eqn{(p,v)} at 
\eqn{v+x \cdot (p-v)}{v+x*(p-v)} with \eqn{x \in [0,1]}. For example, 
we can obtain the node imbalance value of \eqn{v} if \eqn{x=0}, and 
\eqn{x=0.5} would indicate a subdividing node exactly in the middle of 
\eqn{v} and \eqn{p}. \cr
Attention: If \eqn{x=1}, this function will not calculate the node imbalance
value of \eqn{p} with respect to its incoming edge but with respect to the
edge \eqn{(p,v)} itself. This enables us to estimate the 
node imbalance integrals over the entire edge length.

\code{angle3dVec} - Calculates the angle in the interval \eqn{[0,\pi]} 
between two 3D vectors \eqn{a} and \eqn{b}.
Note that the function returns 0 if one entry vector is \eqn{(0,0,0)}.
}
\examples{
imbalSubdiv_A(x=0.5,p=c(1,0,1),v=c(0,0,0),centr_v=c(0.5,0,0),
centr_v_weight=1,edge_weight=1)
imbalSubdiv_alpha(x=0.5,p=c(1,0,1),v=c(0,0,0),centr_v=c(0.5,0,0),
centr_v_weight=1,edge_weight=1)
angle3dVec(a=c(1,0,0),b=c(0,1,0)) # right angle = pi/2 = 1.5707...
}
\author{
Sophie Kersting, Luise Kühn
}
