% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gershunov.R
\name{g_test}
\alias{g_test}
\title{Gershunov test for spurious low-frequency modulations}
\usage{
g_test(x, boot = FALSE, sb = TRUE, check_duration = TRUE)
}
\arguments{
\item{x}{an object of class '"tc_dcc"' as returned from a call to
\code{\link{dcc}} with moving correlations enabled}

\item{boot}{\code{logical} shall the individual correlations be
bootstrapped?  (see details)}

\item{sb}{\code{logical} shall a status bar be drawn?}

\item{check_duration}{\code{logical} should the duration be checked before 
running with individually boostrapped correlations? The default is `TRUE`, 
set to `FALSE` to suppress interactive selections and messages to the
console.}
}
\value{
a \code{data.frame} with p values for the testing the null
    hypothesis that the low-frequency modulation of the
    correlations of the variables with tree-growth can be
    considered as noise.
}
\description{
This function provides a test to decide whether low-frequency
modulations in the relationship between climate and tree-growth
are significantly stronger or weaker than could be expected by
chance.
}
\details{
This function is a multivariate extension of the test for
spurious low-frequency modulations for moving correlations of time
series as proposed by Gershunov et al. (2001). In short, 1000
simulations of random data sets are generated, where the climate
data is simulated as Gaussian noise, and the tree-data as linear
combinations of the climate parameters using the original
coefficients of the correlation function, and an error component
with a variance equal to the variance unexplained by the
individual parameters.
  
For each iteration, a moving correlation function is calculated
with exactly the same settings as the original model. The standard
deviation over the individual windows for each parameter is then
compared to the bootstrapped distribution of the standard
deviation of the simulated data to test for significantly higher
or lower low-frequency modulations.
}
\examples{
\donttest{
dc_cor <- dcc(muc_spruce, muc_clim, 3:9, method = "cor", moving = TRUE)
g_test(dc_cor)
}
}
\references{
Gershunov, A., N. Schneider, and
    T. Barnett. 2001. Low-frequency modulation of the ENSO-Indian
    Monsoon rainfall relationship: Signal or noise? Journal of
    Climate 14:2486-2492.
}
\keyword{test}
