% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_client.R
\name{trem_client_new}
\alias{trem_client_new}
\title{Create a new Tremendous API Client}
\usage{
trem_client_new(api_key = NULL, sandbox = TRUE)
}
\arguments{
\item{api_key}{API key from
\href{https://developers.tremendous.com/}{tremendous.com}. Can either pass in
here as a character string or set for repeated use with
\code{\link{trem_set_api_key}}.}

\item{sandbox}{Logical: \code{TRUE} and any API requests are performed within the
Tremendous sandbox environment, a free and fully-featured environment for
application developing and testing. \code{FALSE} and the API requests are
performed within the Tremendous production environment. \strong{This will involve
sending actual money, so be certain you wish to do this!}}
}
\value{
An object of class 'tremClient' that contains the API Key and
Environment information for easily performing Tremendous API requests.
}
\description{
Create a new Tremendous API Client
}
\examples{

\dontrun{

# Create a client for testing API calls within the Sandbox environment.
test_client <- trem_client_new(api_key = "TEST_YOUR-KEY-HERE",
                                  sandbox = TRUE)

# Create a client for performing API calls within a production environment.
# This client will be able to send actual money!
prod_client <- trem_client_new(api_key = "PROD_YOUR-KEY-HERE",
                               sandbox = FALSE)

}

}
