% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_source_priors.R
\name{one_source_priors}
\alias{one_source_priors}
\title{Bayesian priors - One Source Trophic Position}
\usage{
one_source_priors(bp = FALSE)
}
\arguments{
\item{bp}{logical value that controls whether informed priors are
supplied to the model for \eqn{\delta^{15}}N baseline. Default is
\code{FALSE} meaning the model will use uninformed priors, however, the supplied
\code{data.frame} needs values for \eqn{\delta^{15}}N  baseline (\code{n1}).}
}
\value{
returns priors for one source model to be used in a \code{brms()} call.
}
\description{
Create priors for one source trophic position model derived from
\href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}.
}
\examples{
one_source_priors()

}
\seealso{
\code{\link[brms:brms-package]{brms::brms()}}
}
