% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HACLasso.r
\name{init_values}
\alias{init_values}
\title{\code{init_values} is an auxiliary function for rlassoHAC, for fitting linear models with
the method of least squares where only the variables in X with highest correlations
are considered; taken from package hdm.}
\source{
Victor Chernozhukov, Chris Hansen, Martin Spindler (2016). hdm: High-Dimensional Metrics,
R Journal, 8(2), 185-199. URL https://journal.r-project.org/archive/2016/RJ-2016-040/index.html.
}
\usage{
init_values(X, y, number = 5, intercept = TRUE)
}
\arguments{
\item{X}{Regressors (matrix or object can be coerced to matrix).}

\item{y}{Dependent variable(s).}

\item{number}{How many regressors in X should be considered.}

\item{intercept}{Logical. If TRUE, intercept is included which is not penalized.}
}
\value{
init_values returns a list containing the
following components:
\item{residuals}{Residuals.}
\item{coefficients}{Estimated coefficients.}
}
\description{
\code{init_values} is an auxiliary function for rlassoHAC, for fitting linear models with
the method of least squares where only the variables in X with highest correlations
are considered; taken from package hdm.
}
