% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{auto_clean}
\alias{auto_clean}
\title{Automatic Cleaning of Outliers and Temporary Changes}
\usage{
auto_clean(
  y,
  frequency = 1,
  lambda = NULL,
  types = c("AO", "TC"),
  stlm_opts = list(etsmodel = "AAN"),
  auto_arima_opts = list(max.p = 1, max.q = 1, d = 1, allowdrift = FALSE),
  method = c("sequential", "full"),
  ...
)
}
\arguments{
\item{y}{a univariate xts object.}

\item{frequency}{the frequency of the time series. If the frequency is 1
then seasonal estimation will be turned off. Will also accept multiple
seasonal frequencies.}

\item{lambda}{an optional Box Cox transformation parameter. The routines are
then run on the transformed dataset.}

\item{types}{the types of anomalies to search and decontaminate series from.
Defaults to Additive outliers and temporary changes. Can be enhanced with
trend breaks but not suggested for the purpose of forecasting.}

\item{stlm_opts}{additional arguments to the stlm function.}

\item{auto_arima_opts}{additional arguments to the auto.arima function in
the tso routine.}

\item{method}{whether to apply a sequential identification of anomalies
using STL decomposition in order to only pass the stationary residuals to
the tso function, else to pass the series directly to the tso package.}

\item{\dots}{any additional arguments passed to the tso functions (refer to
the documentation of the tsoutliers package).}
}
\value{
A xts vector.
}
\description{
A wrapper function for \code{\link[tsoutliers]{tso}} from the tsoutliers package.
Takes as input a univariate xts object and returns a series decontaminated from
outliers and temporary changes.
}
\details{
Calls the \code{\link[tsaux]{auto_regressors}} function to obtain the matrix of
regressors and coefficients which are then used to decontaminate the series.
If lambda is not NULL, the series is first transformed to perform the
decontamination and then back transformed afterwards.
}
\author{
Alexios Galanos for this wrapper function.\cr Rob Hyndman for the
forecast package.\cr Javier López-de-Lacalle for the tsoutliers package.
}
