% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{tsensemble.tssim.mixture}
\alias{tsensemble.tssim.mixture}
\alias{tsensemble}
\title{Ensembling of Simulations}
\usage{
\method{tsensemble}{tssim.mixture}(object, weights = NULL, difference = TRUE, ...)
}
\arguments{
\item{object}{an object of class tssim.mixture.}

\item{weights}{the weighting (or probability) matrix for aggregating the
simulations (see details).}

\item{difference}{whether to take the rates of changes first before aggregating
and reconverting to levels.}

\item{...}{additional parameters.}
}
\value{
A vector of the simulated series.
}
\description{
Ensembling of Simulations
}
\details{
When mixing dynamics for the same series, and when series are
not stationary, differences should be used. In that case the rate of change
transformation is applied to each simulated series and then weighted by the
weights matrix. Since the weights matrix will have one more row than is required (the
first row), this can be used to choose how the initial level is generated.
For instance, if we want to use the level of the first simulated series, then
the first row would have a 1 on the first column and zeros in the rest.
For aggregating series, difference should be set to FALSE since we are looking
at summation of data (under the assumption of flow variables). In this case,
the p matrix is usually static by column (i.e. the same weights).
}
