% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvinecopula.R
\docType{class}
\name{dvinecopula-class}
\alias{dvinecopula-class}
\alias{coef,dvinecopula-method}
\alias{show,dvinecopula-method}
\alias{sim,dvinecopula-method}
\alias{predict,dvinecopula-method}
\alias{kendall,dvinecopula-method}
\title{D-vine copula processes}
\usage{
\S4method{coef}{dvinecopula}(object)

\S4method{show}{dvinecopula}(object)

\S4method{sim}{dvinecopula}(object, n = 1000, innov = NA, start = NA)

\S4method{predict}{dvinecopula}(object, data, x, type = "df")

\S4method{kendall}{dvinecopula}(object, lagmax = 20)
}
\arguments{
\item{object}{an object of the class.}

\item{n}{length of realization.}

\item{innov}{vector of innovations of length n.}

\item{start}{vector of start values with length equal to order of process.}

\item{data}{vector of past data values.}

\item{x}{vector of arguments of prediction function.}

\item{type}{type of prediction function ("df" for density, "qf" for quantile function
or "dens" for density).}

\item{lagmax}{maximum value of lag.}
}
\description{
Class of objects for d-vine copula processes.
}
\section{Methods (by generic)}{
\itemize{
\item \code{coef(dvinecopula)}: Coef method for dvinecopula class

\item \code{show(dvinecopula)}: Show method for dvinecopula class

\item \code{sim(dvinecopula)}: Simulation method for dvinecopula class

\item \code{predict(dvinecopula)}: Prediction method for dvinecopula class

\item \code{kendall(dvinecopula)}: Calculate Kendall's tau values for pair copulas in d-vine copula

}}
\section{Slots}{

\describe{
\item{\code{name}}{name of the d-vine copula process.}

\item{\code{modelspec}}{list containing the family, number of parameters and rotations}

\item{\code{pars}}{list comprising of the parameters.}
}}

\examples{
sim(dvinecopula("gauss", 0.5))
mixmod <- dvinecopula(family = c("gumbel", "gauss"), pars = list(1.5, -0.6))
kendall(mixmod)
}
