% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TARMA.sim.R
\name{TARMA.sim}
\alias{TARMA.sim}
\title{Simulation of a two-regime \code{TARMA(p1,p2,q1,q2)} process}
\usage{
TARMA.sim(
  n,
  phi1,
  phi2,
  theta1,
  theta2,
  d = 1,
  thd = 0,
  s1 = 1,
  s2 = 1,
  rand.gen = rnorm,
  innov = rand.gen(n, ...),
  n.start = 500,
  xstart,
  start.innov = rand.gen(n.start, ...),
  ...
)
}
\arguments{
\item{n}{Length of the series.}

\item{phi1}{Vector of \code{p1+1} Autoregressive parameters of the lower regime.
The first element is the intercept.}

\item{phi2}{Vector of \code{p2+1} Autoregressive parameters of the upper regime.
The first element is the intercept.}

\item{theta1}{Vector of \code{q1} Moving Average parameters of the lower regime.}

\item{theta2}{Vector of \code{q2} Moving Average parameters of the upper regime.}

\item{d}{Delay parameter. Defaults to \code{1}.}

\item{thd}{Threshold parameter. Defaults to \code{0}.}

\item{s1}{Innovation variance for the lower regime. Defaults to \code{1}.}

\item{s2}{Innovation variance for the upper regime. Defaults to \code{1}.}

\item{rand.gen}{Optional: a function to generate the innovations. Defaults to \code{rnorm}.}

\item{innov}{Optional: a time series of innovations. If not provided, \code{rand.gen} is used.}

\item{n.start}{Length of the burn-in period. Defaults to \code{500}.}

\item{xstart}{Initial condition as a named list: \cr
\code{$ar}: AR part length \code{k = max(p1,p2,d),  X[k], X[k-1], ... ,X[1]}; \cr
\code{$ma}: MA part length \code{q = ma.ord,   e[q], ... , e[1]}.}

\item{start.innov}{Optional: a time series of innovations for the burn-in period.}

\item{\dots}{Additional arguments for \code{rand.gen}.}
}
\value{
A time series object of class \code{ts} generated from the above model.
}
\description{
\loadmathjax
Simulates from the following two-regime \code{TARMA(p1,p2,q1,q2)} process: \cr

\mjdeqn{X_{t} = \left\lbrace
\begin{array}{ll}
 \phi_{1,0} + \sum_{i=1}^{p_1} \phi_{1,i} X_{t-i} + \sum_{j=1}^{q_1} \theta_{1,j} \varepsilon_{t-j} + \varepsilon_{t}, & \quad\mathrm{if}\quad X_{t-d} \leq \mathrm{thd} \\\\\\
 &\\\\\\
 \phi_{2,0} + \sum_{i=1}^{p_2} \phi_{2,i} X_{t-i} + \sum_{j=1}^{q_2} \theta_{2,j} \varepsilon_{t-j} + \varepsilon_{t}, & \quad\mathrm{if}\quad X_{t-d} > \mathrm{thd}
\end{array}
\right.
}{X[t] =
  = \phi[1,0] + \phi[1,1]X[t-1] + ... + \phi[1,p1]X[t-p1] + \theta[1,1]\epsilon[t-1] + ... +  \theta[1,q]\epsilon[t-q1] + \epsilon[t] --   if  X[t-d] <=  thd

  = \phi[2,0] + \phi[2,1]X[t-1] + ... + \phi[2,p2]X[t-p2] + \theta[2,1]\epsilon[t-1] + ... +  \theta[2,q]\epsilon[t-q2]  + \epsilon[t] --  if  X[t-d] >  thd}
}
\details{
Note that the parameters are not checked for ergodicity.
}
\examples{
## a TARMA(1,1,1,1) model
set.seed(123)
x <- TARMA.sim(n=100, phi1=c(0.5,-0.5), phi2=c(0.0,0.8), theta1=-0.5, theta2=0.5, d=1, thd=0.2)

## a TARMA(1,2,1,1) model
x <- TARMA.sim(n=100,phi1=c(0.5,-0.5,0),phi2=c(0,0.5,0.3),theta1=-0.5,theta2=0.5,d=1,thd=0.2)

}
\references{
\itemize{
\item \insertRef{Gia21}{tseriesTARMA}
}
}
\author{
Simone Giannerini, \email{simone.giannerini@uniud.it}

Greta Goracci, \email{greta.goracci@unibz.it}
}
