% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TARMAur.test.R
\name{TARMAur.test}
\alias{TARMAur.test}
\title{Unit root supLM test for an integrated MA versus a stationary TARMA process}
\usage{
TARMAur.test(x, pa = 0.25, pb = 0.75, thd.range, method = "ML", ...)
}
\arguments{
\item{x}{A univariate vector or time series.}

\item{pa}{Real number in \code{[0,1]}. Sets the lower limit for the threshold search to the \code{100*pa}-th sample percentile.
The default is \code{0.25}}

\item{pb}{Real number in \code{[0,1]}. Sets the upper limit for the threshold search to the \code{100*pb}-th sample percentile.
The default is \code{0.75}}

\item{thd.range}{Vector of optional user defined threshold range. If missing then \code{pa} and \code{pb} are used.}

\item{method}{Fitting method to be passed to \code{arima}.}

\item{\dots}{Additional arguments to be passed to \code{arima}.}
}
\value{
An object of class \code{TARMAtest} with components:
\describe{
\item{\code{statistic}}{The value of the supLM statistic.}
\item{\code{parameter}}{A named vector: \code{threshold} is the value that maximises the Lagrange Multiplier values.}
\item{\code{test.v}}{Vector of values of the LM statistic for each threshold given in \code{thd.range}.}
\item{\code{thd.range}}{Range of values of the threshold.}
\item{\code{fit.ARMA}}{The null model: IMA(1) fit over \code{x}.}
\item{\code{sigma2}}{Estimated innovation variance from the IMA fit.}
\item{\code{data.name}}{A character string giving the name of the data.}
\item{\code{p.value}}{The p-value of the test. It is \code{NULL} for the asymptotic test.}
\item{\code{method}}{A character string indicating the type of test performed.}
\item{\code{d}}{The delay parameter.}
\item{\code{pa}}{Lower threshold quantile.}
}
}
\description{
Implements a supremum Lagrange Multiplier unit root test for the null hypiythesis of a integrated MA  process versus
a stationary TARMA process.
}
\details{
Implements an asymptotic supremum Lagrange Multiplier test to test an integrate MA(1) specification versus a
stationary TARMA(1,1) specification. This is an asymptotic test and the value of the test statistic has to be compared with the critical
values tabulated in \insertCite{Cha24}{tseriesTARMA} and available in \code{\link{supLMQur}}.
The relevant critical values are automatically shown upon printing the test, see \code{\link{print.TARMAtest}}.
}
\examples{
## a TARMA(1,1,1,1) 
set.seed(123)
x1    <- TARMA.sim(n=100, phi1=c(0.5,-0.5), phi2=c(0.0,0.8), theta1=0.5, theta2=0.5, d=1, thd=0.2)
TARMAur.test(x1)


## a IMA(1,1)
x2   <- arima.sim(n=100, model=list(order = c(0,1,1),ma=0.6))
TARMAur.test(x2)


}
\references{
\itemize{
\item \insertRef{Cha24}{tseriesTARMA}
}
}
\seealso{
\code{\link{TARMAur.test.B}} for the bootstrap version of the test.
\code{\link{print.TARMAtest}} for the print method.
}
\author{
Simone Giannerini, \email{simone.giannerini@uniud.it}

Greta Goracci, \email{greta.goracci@unibz.it}
}
