% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_helpers.R
\name{collapse_list}
\alias{collapse_list}
\title{Collapse a list of data frames or tibbles into a single data frame}
\usage{
collapse_list(
  data,
  ...,
  col_id = "category",
  label = NULL,
  pluck = NULL,
  as_proportion = FALSE,
  name_separator = "_",
  label_separator = "__"
)
}
\arguments{
\item{data}{A list of data frames or tibbles to be collapsed.}

\item{...}{Additional arguments passed to \code{dplyr::filter()}.}

\item{col_id}{The name of the column to be created for the category.}

\item{label}{A label for the category column. If \code{NULL}, defaults to "Category".}

\item{pluck}{A character vector of column names to pluck from the data frames. If \code{NULL}, all columns are retained.}

\item{as_proportion}{If \code{TRUE}, the frequency values will be converted to proportions. Default is \code{FALSE}.}

\item{name_separator}{A string to separate the names of the columns in the output data frame. Default is "_".}

\item{label_separator}{A string to separate the labels of the columns in the output data frame. Default is "__".}
}
\value{
A data frame with the specified category column and the frequency and percent columns for each category, along with any additional columns specified in \code{pluck}.
}
\description{
Collapse a list of data frames or tibbles into a single data frame
}
\examples{
person_record |>
  generate_frequency(
    seeing,
    hearing,
    walking,
    remembering,
    self_caring,
    communicating
  ) |>
  collapse_list()
}
