% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsriadditive.R
\name{predict.tsriadditive}
\alias{predict.tsriadditive}
\title{Predict method for Additive Hazards Model with Two Stage Residual Inclusion Method Fits}
\usage{
\method{predict}{tsriadditive}(object, newtreatment = NULL,
  newIV = NULL, newcovariates = NULL, ...)
}
\arguments{
\item{object}{an object of class "tsriadditive", usually, a result of a call to tsriadditive.}

\item{newtreatment}{a new treatment value.}

\item{newIV}{a new instrumental variable value.}

\item{newcovariates}{a new observed covariates.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
predict.tsriadditive produces a venctor of predictions based on new values.
A list with the following components is returned:
\item{newobsz}{the vector grouping newtreatment, new IV and newcovariates}
\item{score_pred}{the predicted scores}
\item{hazard_pred}{the predicted baseline hazards function}
\item{surival_pred}{the predicted surival function}
}
\description{
Predicted values based on tsriadditive object.
}
\examples{
survtime <- rexp(100)
cause <- rbinom(100, 1, 0.7)
treatment <- rbinom(100, 1, 0.5)
IV <- rnorm(100)
covariates <- rnorm(100)
fit <- tsriadditive(survtime, cause, treatment, IV, covariates)
predict(fit, 1, 0, 0)
}
