% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttt.R
\name{ttt}
\alias{ttt}
\alias{ttt.data.frame}
\alias{ttt.formula}
\alias{ttt.numeric}
\alias{ttt.ftable}
\title{Formatted tables the easy way}
\usage{
ttt(x, ...)

\method{ttt}{data.frame}(
  x,
  formula,
  ...,
  render,
  lab,
  caption,
  footnote,
  expand.along = c("rows", "columns"),
  drop = c("both", "rows", "columns", "none"),
  collapse.cells = TRUE,
  topclass = NULL,
  id = NULL,
  css = NULL,
  row.names = TRUE
)

\method{ttt}{formula}(
  x,
  data,
  ...,
  render,
  lab,
  caption,
  footnote,
  expand.along = c("rows", "columns"),
  drop = c("both", "rows", "columns", "none"),
  collapse.cells = TRUE,
  topclass = NULL,
  id = NULL,
  css = NULL
)

\method{ttt}{numeric}(
  x,
  rowvars,
  colvars,
  ...,
  render,
  lab,
  caption,
  footnote,
  expand.along = c("rows", "columns"),
  drop = c("both", "rows", "columns", "none"),
  collapse.cells = TRUE,
  topclass = NULL,
  id = NULL,
  css = NULL
)

\method{ttt}{ftable}(
  x,
  text = matrix(as.character(x), nrow(x)),
  lab,
  caption,
  footnote,
  drop = c("both", "rows", "columns", "none"),
  collapse.cells = TRUE,
  html.class = NULL,
  topclass = NULL,
  id = NULL,
  css = NULL,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{...}{Additional arguments passed to \code{render}.}

\item{formula}{A three-part formula of the form \code{v ~ r1 + r2 ~
c1 + c2} where \code{v} specifies a column of values, while \code{r1,
r2} specify row variables and \code{c1, c2} column variables for
splitting the values.}

\item{render}{A function to render the contents of each cell to character data.}

\item{lab}{Specify the contents of an extra table cell spanning
over all column labels.}

\item{caption}{A character string to be added as a caption to the table.
The default is to omit the caption.}

\item{footnote}{A character string to be added as a footnote to the table.
The default is to omit the footnote.}

\item{expand.along}{Specify the direction to expand the table when render
returns a (named) vector.}

\item{drop}{If \code{TRUE} (the default), rows and columns with zero counts
will be dropped.}

\item{collapse.cells}{If \code{TRUE} (the default), row/column header cells
will be collapsed (merged) where appropriate.}

\item{topclass}{A character string to be used as \code{class} attribute for
the top-level \code{<table>} element.}

\item{id}{A character string to be used as \code{id} attribute for
the top-level \code{<table>} element.}

\item{css}{A character string containing CSS code to be added before the
top-level \code{<table>} element.}

\item{row.names}{If \code{TRUE} (the default), row names will be shown in the
first column of the table. Set to \code{FALSE} to suppress row names.
Only applies when displaying whole \code{data.frame}.}

\item{data}{A data.frame.}

\item{rowvars}{A list of row variables for splitting the data.}

\item{colvars}{A list of column variables for splitting the data.}

\item{text}{A character matrix containing the textual content of each table cell.}

\item{html.class}{A character matrix with the same dimensions as \code{text}
specifying a class attribute for the corresponding \code{<td>} element.}
}
\value{
A \code{character} which contains an HTML table fragment. It has
additional class attributes that cause it to be displayed in a browser in an
interactive context, and rendered as HTML in a \code{knitr} context.
}
\description{
\code{ttt} stands for ``The Table Tool'' (or, if you prefer, ``Tables! Tables! Tables!'').
It allows you to creates formatted HTML tables of in a flexible and
convenient way.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: The \code{data.frame} method.

\item \code{formula}: The \code{formula} method.

\item \code{numeric}: The \code{numeric} method.

\item \code{ftable}: The \code{ftable} method.
}}

\examples{
# mtcars examples
ttt(mtcars)
ttt(mtcars, mpg ~ gear | cyl, lab="Cylinders")
ttt(mpg ~ gear | cyl, data=mtcars, lab="Cylinders")
ttt(rownames(mtcars) ~ gear | cyl, data=mtcars,
  render=paste, collapse="<br/>", lab="Cylinders")

# OrchardSprays examples
ttt(head(OrchardSprays, 12))
ttt(head(OrchardSprays, 12), row.names=FALSE)
ttt(treatment ~ rowpos | colpos, data=OrchardSprays, lab="colpos")
ttt(paste(treatment, decrease, sep="<br/>") ~ rowpos | colpos, data=OrchardSprays, lab="colpos")

rndr.meansd <- function(x) formatC(c(Mean=mean(x), SD=sd(x)), digits=3)
ttt(decrease ~ treatment, data=OrchardSprays, render=rndr.meansd, expand.along="rows")
ttt(decrease ~ treatment, data=OrchardSprays, render=rndr.meansd, expand.along="columns")

# ToothGrowth examples
ttt(len ~ dose | supp, data=ToothGrowth, lab="Mean (SD)",
  render=function(x) sprintf("\%0.3g (\%0.3g)", mean(x), sd(x)))

ttt(len ~ dose | supp, data=ToothGrowth, lab="Supplement Type",
  render=rndr.meansd)

ttt(len ~ dose | supp, data=ToothGrowth, lab="Supplement Type",
  render=rndr.meansd, expand.along="columns")

}
\keyword{utilities}
